package ru.yandex.intranet.d.web.model.settings

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * YP usage sync settings DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "YP usage sync settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class YpUsageSyncSettingsDto @JsonCreator constructor(
    @get:Schema(description = "CPU resource type id.")
    val cpuResourceType: String?,
    @get:Schema(description = "Pre-stable CPU resource type id.")
    val preStableCpuResourceType: String?,
    @get:Schema(description = "Cluster segmentation id.")
    val clusterSegmentation: String?,
    @get:Schema(description = "Node segment segmentation id.")
    val nodeSegmentSegmentation: String?,
    @get:Schema(description = "Pre-stable cluster segmentation id.")
    val preStableClusterSegmentation: String?,
    @get:Schema(description = "Pre-stable node segment segmentation id.")
    val preStableNodeSegmentSegmentation: String?,
    @get:Schema(description = "Default node segment id.")
    val defaultNodeSegment: String?,
    @get:Schema(description = "Dev node segment id.")
    val devNodeSegment: String?,
    @get:Schema(description = "Pre-stable default node segment id.")
    val preStableDefaultNodeSegment: String?,
    @get:Schema(description = "Pre-stable dev node segment id.")
    val preStableDevNodeSegment: String?,
    @get:Schema(description = "CPU cores units ensemble id.")
    val coresUnitsEnsemble: String?,
    @get:Schema(description = "CPU core unit id.")
    val coresUnit: String?,
    @get:Schema(description = "'Sync enabled' flag.")
    val syncEnabled: Boolean?
)
