package ru.yandex.intranet.d.web.model.settings

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * YT usage sync settings DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "YT usage sync settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class YtUsageSyncSettingsDto @JsonCreator constructor(
    @get:Schema(description = "'CPU strong' resource type id.")
    val cpuStrongResourceType: String?,
    @get:Schema(description = "'Pool tree' segmentation id.")
    val poolTreeSegmentation: String?,
    @get:Schema(description = "'Physical pool tree' segment id.")
    val physicalPoolTreeSegment: String?,
    @get:Schema(description = "'Cluster' segmentation id.")
    val clusterSegmentation: String?,
    @get:Schema(description = "'Scope' segmentation id.")
    val scopeSegmentation: String?,
    @get:Schema(description = "'Compute scope' segment id.")
    val computeScopeSegment: String?,
    @get:Schema(description = "'Sync enabled' flag.")
    val syncEnabled: Boolean?,
    @get:Schema(description = "CPU metric grid spacing, seconds.")
    val cpuMetricGridSpacingSeconds: Long?,
    @get:Schema(description = "CPU metric units ensemble id.")
    val cpuMetricUnitsEnsemble: String?,
    @get:Schema(description = "CPU metric unit id.")
    val cpuMetricUnit: String?
)
