package ru.yandex.intranet.d.web.model.tracker;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Request for create ticket in tracker.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Request for create ticket in tracker.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TrackerCreateTicketDto {

    private final String queue;
    private final String summary;
    private final String description;
    private final String createdBy;
    private final List<Long> components;
    private final List<String> tags;
    private final String unique;

    @JsonCreator
    public TrackerCreateTicketDto(String queue, String summary, String description, String createdBy,
                                  List<Long> components, List<String> tags, String unique) {
        this.queue = queue;
        this.summary = summary;
        this.description = description;
        this.createdBy = createdBy;
        this.components = components;
        this.tags = tags;
        this.unique = unique;
    }

    @Schema(description = "Queue name", required = true)
    public String getQueue() {
        return queue;
    }

    @Schema(description = "Ticket name", required = true)
    public String getSummary() {
        return summary;
    }

    @Schema(description = "Ticket description")
    public String getDescription() {
        return description;
    }

    @Schema(description = "Ticket author username")
    public String getCreatedBy() {
        return createdBy;
    }

    @Schema(description = "List of component ids for ticket")
    public List<Long> getComponents() {
        return components;
    }

    @Schema(description = "List of tags for ticket")
    public List<String> getTags() {
        return tags;
    }

    @Schema(description = "Unique value for retryable", required = true)
    public String getUnique() {
        return unique;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackerCreateTicketDto that = (TrackerCreateTicketDto) o;
        return Objects.equals(queue, that.queue) && Objects.equals(summary, that.summary) &&
                Objects.equals(description, that.description) && Objects.equals(createdBy, that.createdBy) &&
                Objects.equals(components, that.components) && Objects.equals(tags, that.tags) &&
                Objects.equals(unique, that.unique);
    }

    @Override
    public int hashCode() {
        return Objects.hash(queue, summary, description, createdBy, components, tags, unique);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
