package ru.yandex.intranet.d.web.model.tracker;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Response for create ticket in tracker.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Response for create ticket in tracker.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class TrackerCreateTicketResponseDto {

    private final String key;

    @JsonCreator
    public TrackerCreateTicketResponseDto(@JsonProperty("key") String key) {
        this.key = key;
    }

    @Schema(description = "Key of the ticket", required = true)
    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackerCreateTicketResponseDto that = (TrackerCreateTicketResponseDto) o;
        return Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
