package ru.yandex.intranet.d.web.model.tracker;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Response from tracker with errors.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Response from tracker with errors.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TrackerErrorDto {

    private final Map<String, String> errors;
    private final List<String> errorMessages;
    private final Integer statusCode;

    @JsonCreator
    public TrackerErrorDto(@JsonProperty("errors") Map<String, String> errors,
                           @JsonProperty("errorMessages") List<String> errorMessages,
                           @JsonProperty("statusCode") Integer statusCode) {
        this.errors = errors;
        this.errorMessages = errorMessages;
        this.statusCode = statusCode;
    }

    @Schema(description = "Map with errors")
    public Map<String, String> getErrors() {
        return errors;
    }

    @Schema(description = "List of error messages")
    public List<String> getErrorMessages() {
        return errorMessages;
    }

    @Schema(description = "Response status code")
    public Integer getStatusCode() {
        return statusCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackerErrorDto that = (TrackerErrorDto) o;
        return Objects.equals(errors, that.errors) && Objects.equals(errorMessages, that.errorMessages)
                && Objects.equals(statusCode, that.statusCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errors, errorMessages, statusCode);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
