package ru.yandex.intranet.d.web.model.tracker;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.services.tracker.TrackerIssueResolution;

/**
 * Request for execute transition in tracker
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Request for execute transition in tracker.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TrackerTransitionExecuteDto {

    private final String resolution;

    @JsonCreator
    public TrackerTransitionExecuteDto(String resolution) {
        this.resolution = resolution;
    }

    public TrackerTransitionExecuteDto(TrackerIssueResolution resolution) {
        this.resolution = resolution.toString();
    }

    @Schema(description = "Resolution of the ticket")
    public String getResolution() {
        return resolution;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackerTransitionExecuteDto that = (TrackerTransitionExecuteDto) o;
        return Objects.equals(resolution, that.resolution);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resolution);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
