package ru.yandex.intranet.d.web.model.tracker;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Request for update ticket in tracker.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Request for update ticket in tracker.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TrackerUpdateTicketDto {

    private final String summary;
    private final String description;
    private final List<Long> components;
    private final List<String> tags;

    @JsonCreator
    public TrackerUpdateTicketDto(String summary, String description,
                                  List<Long> components, List<String> tags) {
        this.summary = summary;
        this.description = description;
        this.components = components;
        this.tags = tags;
    }

    @Schema(description = "Ticket name", required = true)
    public String getSummary() {
        return summary;
    }

    @Schema(description = "Ticket description")
    public String getDescription() {
        return description;
    }

    @Schema(description = "List of component ids for ticket")
    public List<Long> getComponents() {
        return components;
    }

    @Schema(description = "List of tags for ticket")
    public List<String> getTags() {
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackerUpdateTicketDto that = (TrackerUpdateTicketDto) o;
        return Objects.equals(summary, that.summary) &&
                Objects.equals(description, that.description) &&
                Objects.equals(components, that.components) && Objects.equals(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(summary, description, components, tags);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
