package ru.yandex.intranet.d.web.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.transfers.TransferRequestEventType;

/**
 * Transfer request history event type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request history event type.")
public enum TransferRequestHistoryEventTypeDto {

    UNKNOWN,
    CREATED,
    UPDATED,
    APPLIED,
    REJECTED,
    CANCELLED,
    FAILED,
    BECAME_STALE,
    VOTED;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static TransferRequestHistoryEventTypeDto fromJsonValue(String value) {
        try {
            return TransferRequestHistoryEventTypeDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return TransferRequestHistoryEventTypeDto.UNKNOWN;
        }
    }

    public static TransferRequestHistoryEventTypeDto fromModel(TransferRequestEventType model) {
        switch (model) {
            case CREATED:
                return TransferRequestHistoryEventTypeDto.CREATED;
            case UPDATED:
                return TransferRequestHistoryEventTypeDto.UPDATED;
            case APPLIED:
                return TransferRequestHistoryEventTypeDto.APPLIED;
            case REJECTED:
                return TransferRequestHistoryEventTypeDto.REJECTED;
            case CANCELLED:
                return TransferRequestHistoryEventTypeDto.CANCELLED;
            case FAILED:
                return TransferRequestHistoryEventTypeDto.FAILED;
            case BECAME_STALE:
                return TransferRequestHistoryEventTypeDto.BECAME_STALE;
            case VOTED:
                return TransferRequestHistoryEventTypeDto.VOTED;
            default:
                throw new IllegalArgumentException("Unexpected transfer request event type " + model);
        }
    }

}
