package ru.yandex.intranet.d.web.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.transfers.TransferRequestStatus;

/**
 * Transfer request status DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request status.")
public enum TransferRequestStatusDto {

    UNKNOWN,
    PENDING,
    APPLIED,
    REJECTED,
    CANCELLED,
    FAILED,
    STALE,
    EXECUTING,
    PARTLY_APPLIED;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static TransferRequestStatusDto fromJsonValue(String value) {
        try {
            return TransferRequestStatusDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return TransferRequestStatusDto.UNKNOWN;
        }
    }

    public static TransferRequestStatusDto fromModel(TransferRequestStatus model) {
        return switch (model) {
            case PENDING -> TransferRequestStatusDto.PENDING;
            case APPLIED -> TransferRequestStatusDto.APPLIED;
            case REJECTED -> TransferRequestStatusDto.REJECTED;
            case CANCELLED -> TransferRequestStatusDto.CANCELLED;
            case FAILED -> TransferRequestStatusDto.FAILED;
            case STALE -> TransferRequestStatusDto.STALE;
            case EXECUTING -> TransferRequestStatusDto.EXECUTING;
            case PARTLY_APPLIED -> TransferRequestStatusDto.PARTLY_APPLIED;
        };
    }

}
