package ru.yandex.intranet.d.web.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.transfers.TransferRequestSubtype;

/**
 * Transfer request subtype DTO.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Transfer request subtype.")
public enum TransferRequestSubtypeDto {
    UNKNOWN,

    //FOLDER_TRANSFER
    DEFAULT_FOLDER_TRANSFER,

    //QUOTA_TRANSFER
    DEFAULT_QUOTA_TRANSFER,

    //ACCOUNT_TRANSFER
    DEFAULT_ACCOUNT_TRANSFER,

    //PROVISION_TRANSFER
    DEFAULT_PROVISION_TRANSFER,
    EXCHANGE_PROVISION_TRANSFER,
    RESERVE_PROVISION_TRANSFER,
    LOAN_PROVISION_TRANSFER,

    //RESERVE_TRANSFER
    DEFAULT_RESERVE_TRANSFER;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static TransferRequestSubtypeDto fromJsonValue(String value) {
        try {
            return TransferRequestSubtypeDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return TransferRequestSubtypeDto.UNKNOWN;
        }
    }

    public static TransferRequestSubtypeDto fromModel(TransferRequestSubtype model) {
        return switch (model) {
            case DEFAULT_FOLDER_TRANSFER -> TransferRequestSubtypeDto.DEFAULT_FOLDER_TRANSFER;
            case DEFAULT_QUOTA_TRANSFER -> TransferRequestSubtypeDto.DEFAULT_QUOTA_TRANSFER;
            case DEFAULT_ACCOUNT_TRANSFER -> TransferRequestSubtypeDto.DEFAULT_ACCOUNT_TRANSFER;
            case DEFAULT_PROVISION_TRANSFER -> TransferRequestSubtypeDto.DEFAULT_PROVISION_TRANSFER;
            case EXCHANGE_PROVISION_TRANSFER -> TransferRequestSubtypeDto.EXCHANGE_PROVISION_TRANSFER;
            case RESERVE_PROVISION_TRANSFER -> TransferRequestSubtypeDto.RESERVE_PROVISION_TRANSFER;
            case LOAN_PROVISION_TRANSFER -> TransferRequestSubtypeDto.LOAN_PROVISION_TRANSFER;
            case DEFAULT_RESERVE_TRANSFER -> TransferRequestSubtypeDto.DEFAULT_RESERVE_TRANSFER;
        };
    }
}
