package ru.yandex.intranet.d.web.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.transfers.TransferRequestType;

/**
 * Transfer request type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request type.")
public enum TransferRequestTypeDto {

    UNKNOWN,
    FOLDER_TRANSFER,
    QUOTA_TRANSFER,
    ACCOUNT_TRANSFER,
    PROVISION_TRANSFER,
    RESERVE_TRANSFER;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static TransferRequestTypeDto fromJsonValue(String value) {
        try {
            return TransferRequestTypeDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return TransferRequestTypeDto.UNKNOWN;
        }
    }

    public static TransferRequestTypeDto fromModel(TransferRequestType model) {
        return switch (model) {
            case FOLDER_TRANSFER -> TransferRequestTypeDto.FOLDER_TRANSFER;
            case QUOTA_TRANSFER -> TransferRequestTypeDto.QUOTA_TRANSFER;
            case ACCOUNT_TRANSFER -> TransferRequestTypeDto.ACCOUNT_TRANSFER;
            case PROVISION_TRANSFER -> TransferRequestTypeDto.PROVISION_TRANSFER;
            case RESERVE_TRANSFER -> TransferRequestTypeDto.RESERVE_TRANSFER;
        };
    }

}
