package ru.yandex.intranet.d.web.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.transfers.VoteType;

/**
 * Transfer request vote type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request vote type.")
public enum TransferRequestVoteTypeDto {

    UNKNOWN,
    CONFIRM,
    REJECT,
    ABSTAIN;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static TransferRequestVoteTypeDto fromJsonValue(String value) {
        try {
            return TransferRequestVoteTypeDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return TransferRequestVoteTypeDto.UNKNOWN;
        }
    }

    public static TransferRequestVoteTypeDto fromModel(VoteType model) {
        return switch (model) {
            case CONFIRM -> TransferRequestVoteTypeDto.CONFIRM;
            case REJECT -> TransferRequestVoteTypeDto.REJECT;
            case ABSTAIN -> TransferRequestVoteTypeDto.ABSTAIN;
        };
    }

}
