package ru.yandex.intranet.d.web.model.transfers.api;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Cancel transfer request input DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Cancel transfer request parameters.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CancelTransferRequestInputDto {

    private final Long version;

    @JsonCreator
    public CancelTransferRequestInputDto(Long version) {
        this.version = version;
    }

    @Schema(description = "Current transfer request version.", required = true)
    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CancelTransferRequestInputDto that = (CancelTransferRequestInputDto) o;
        return Objects.equals(version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(version);
    }

    @Override
    public String toString() {
        return "CancelTransferRequestInputDto{" +
                "version=" + version +
                '}';
    }

}
