package ru.yandex.intranet.d.web.model.transfers.api;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quota resource transfer DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Quota resource transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateQuotaResourceTransferDto {

    private final String providerId;
    private final String resourceId;
    private final Long delta;
    private final String deltaUnitKey;

    @JsonCreator
    public CreateQuotaResourceTransferDto(String providerId, String resourceId, Long delta, String deltaUnitKey) {
        this.providerId = providerId;
        this.resourceId = resourceId;
        this.delta = delta;
        this.deltaUnitKey = deltaUnitKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Provider id.", required = true)
    public Optional<String> getProviderId() {
        return Optional.ofNullable(providerId);
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Transferred resource amount.", required = true)
    public Optional<Long> getDelta() {
        return Optional.ofNullable(delta);
    }

    @Schema(description = "Transferred resource amount unit key.", required = true)
    public Optional<String> getDeltaUnitKey() {
        return Optional.ofNullable(deltaUnitKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateQuotaResourceTransferDto that = (CreateQuotaResourceTransferDto) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(delta, that.delta) &&
                Objects.equals(deltaUnitKey, that.deltaUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, resourceId, delta, deltaUnitKey);
    }

    @Override
    public String toString() {
        return "CreateQuotaResourceTransferDto{" +
                "providerId='" + providerId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", delta=" + delta +
                ", deltaUnitKey='" + deltaUnitKey + '\'' +
                '}';
    }

    public static final class Builder {

        private String providerId;
        private String resourceId;
        private Long delta;
        private String deltaUnitKey;

        private Builder() {
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder delta(Long delta) {
            this.delta = delta;
            return this;
        }

        public Builder deltaUnitKey(String deltaUnitKey) {
            this.deltaUnitKey = deltaUnitKey;
            return this;
        }

        public CreateQuotaResourceTransferDto build() {
            return new CreateQuotaResourceTransferDto(providerId, resourceId, delta, deltaUnitKey);
        }

    }

}
