package ru.yandex.intranet.d.web.model.transfers.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quota transfer parameters DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Quota transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateQuotaTransferDto {

    private final String folderId;
    private final List<CreateQuotaResourceTransferDto> resourceTransfers;

    @JsonCreator
    public CreateQuotaTransferDto(String folderId,
                                  List<CreateQuotaResourceTransferDto> resourceTransfers) {
        this.folderId = folderId;
        this.resourceTransfers = resourceTransfers;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Folder id.", required = true)
    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    @Schema(description = "Quota resource transfers.", required = true)
    public Optional<List<CreateQuotaResourceTransferDto>> getResourceTransfers() {
        return Optional.ofNullable(resourceTransfers);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateQuotaTransferDto that = (CreateQuotaTransferDto) o;
        return Objects.equals(folderId, that.folderId) &&
                Objects.equals(resourceTransfers, that.resourceTransfers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, resourceTransfers);
    }

    @Override
    public String toString() {
        return "CreateQuotaTransferDto{" +
                "folderId='" + folderId + '\'' +
                ", resourceTransfers=" + resourceTransfers +
                '}';
    }

    public static final class Builder {

        private final List<CreateQuotaResourceTransferDto> resourceTransfers = new ArrayList<>();

        private String folderId;

        private Builder() {
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder addResourceTransfer(CreateQuotaResourceTransferDto resourceTransfer) {
            this.resourceTransfers.add(resourceTransfer);
            return this;
        }

        public Builder addResourceTransfers(CreateQuotaResourceTransferDto... resourceTransfers) {
            this.resourceTransfers.addAll(Arrays.asList(resourceTransfers));
            return this;
        }

        public Builder addResourceTransfers(Collection<? extends CreateQuotaResourceTransferDto> resourceTransfers) {
            this.resourceTransfers.addAll(resourceTransfers);
            return this;
        }

        public CreateQuotaTransferDto build() {
            return new CreateQuotaTransferDto(folderId, resourceTransfers);
        }

    }

}
