package ru.yandex.intranet.d.web.model.transfers.api

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Provision quota transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ProvisionTransferDto(
    @Schema(description = "Source account id.", required = true)
    val sourceAccountId: String,
    @Schema(description = "Destination account id.", required = true)
    val destinationAccountId: String,
    @Schema(description = "Source folder id.", required = true)
    val sourceFolderId: String,
    @Schema(description = "Destination account id.", required = true)
    val destinationFolderId: String,
    @Schema(description = "Source service id.", required = true)
    val sourceServiceId: String,
    @Schema(description = "Destination account id.", required = true)
    val destinationServiceId: String,
    @Schema(description = "Source account quota transfers.", required = true)
    val sourceAccountTransfers: List<QuotaResourceTransferDto>,
    @Schema(description = "Destination account quota transfers.", required = true)
    val destinationAccountTransfers: List<QuotaResourceTransferDto>,
    @Schema(description = "Operation id.", required = false)
    val operationId: String?,
)
