package ru.yandex.intranet.d.web.model.transfers.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.LocalDate

/**
 * Transfer request loan borrow metadata DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request loan borrow metadata.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class TransferLoanBorrowMetaDto @JsonCreator constructor(
    @Schema(description = "Due date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    val dueDate: LocalDate,
    @Schema(description = "Loan ids.")
    val loanIds: List<String>
)
