package ru.yandex.intranet.d.web.model.transfers.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Transfer request votes DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request votes.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TransferRequestVotesDto {

    private final List<TransferRequestVoterDto> voters;

    @JsonCreator
    public TransferRequestVotesDto(List<TransferRequestVoterDto> voters) {
        this.voters = voters;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Transfer request voters list.", required = true)
    public List<TransferRequestVoterDto> getVoters() {
        return voters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferRequestVotesDto that = (TransferRequestVotesDto) o;
        return Objects.equals(voters, that.voters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(voters);
    }

    @Override
    public String toString() {
        return "TransferRequestVotesDto{" +
                "voters=" + voters +
                '}';
    }

    public static final class Builder {

        private final List<TransferRequestVoterDto> voters = new ArrayList<>();

        private Builder() {
        }

        public Builder addVoter(TransferRequestVoterDto voter) {
            this.voters.add(voter);
            return this;
        }

        public Builder addVoters(TransferRequestVoterDto... voters) {
            this.voters.addAll(Arrays.asList(voters));
            return this;
        }

        public Builder addVoters(Collection<? extends TransferRequestVoterDto> voters) {
            this.voters.addAll(voters);
            return this;
        }

        public TransferRequestVotesDto build() {
            return new TransferRequestVotesDto(voters);
        }

    }

}
