package ru.yandex.intranet.d.web.model.transfers.api;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.transfers.TransferRequestVoteTypeDto;

/**
 * Transfer request voting DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request vote.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TransferRequestVotingDto {

    private final Long version;
    private final TransferRequestVoteTypeDto voteType;

    @JsonCreator
    public TransferRequestVotingDto(Long version, TransferRequestVoteTypeDto voteType) {
        this.version = version;
        this.voteType = voteType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Current transfer request version.", required = true)
    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    @Schema(description = "Vote type.", required = true)
    public Optional<TransferRequestVoteTypeDto> getVoteType() {
        return Optional.ofNullable(voteType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferRequestVotingDto that = (TransferRequestVotingDto) o;
        return Objects.equals(version, that.version) &&
                voteType == that.voteType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(version, voteType);
    }

    @Override
    public String toString() {
        return "TransferRequestVotingDto{" +
                "version=" + version +
                ", voteType=" + voteType +
                '}';
    }

    public static final class Builder {

        private Long version;
        private TransferRequestVoteTypeDto voteType;

        private Builder() {
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder voteType(TransferRequestVoteTypeDto voteType) {
            this.voteType = voteType;
            return this;
        }

        public TransferRequestVotingDto build() {
            return new TransferRequestVotingDto(version, voteType);
        }

    }

}
