package ru.yandex.intranet.d.web.model.transfers.front;

import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountsSpaceDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontFolderDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontProviderDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentationDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceTypeDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontServiceDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontUnitDictionaryElementDto;
import ru.yandex.intranet.d.web.model.dictionaries.FrontUserDictionaryElementDto;

/**
 * DictionaryBuilder.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 16-02-2022
 */
public interface DictionaryBuilder {
    DictionaryBuilder addFolder(String folderId, FrontFolderDictionaryElementDto folder);

    DictionaryBuilder addService(String serviceId, FrontServiceDictionaryElementDto service);

    DictionaryBuilder addResource(String resourceId, FrontResourceDictionaryElementDto resource);

    DictionaryBuilder addProvider(String providerId, FrontProviderDictionaryElementDto provider);

    DictionaryBuilder addUnit(String unitId, FrontUnitDictionaryElementDto unit);

    DictionaryBuilder addUser(String userId, FrontUserDictionaryElementDto user);

    DictionaryBuilder addAccount(String accountId, FrontAccountDictionaryElementDto account);

    DictionaryBuilder addResourceType(String resourceTypeId, FrontResourceTypeDictionaryElementDto resourceType);

    DictionaryBuilder addAccountsSpace(String accountsSpaceId, FrontAccountsSpaceDictionaryElementDto accountsSpace);

    DictionaryBuilder addSegmentation(
            String segmentationId, FrontResourceSegmentationDictionaryElementDto segmentation
    );

    DictionaryBuilder addSegment(String segmentId, FrontResourceSegmentDictionaryElementDto segment);
}
