package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import ru.yandex.intranet.d.web.model.transfers.TransferRequestTypeDto;

/**
 * Create base transfer request DTO.
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public abstract class FrontBaseCreateTransferRequestDto {

    private final TransferRequestTypeDto requestType;
    private final FrontCreateTransferRequestParametersDto parameters;
    private final FrontTransferLoanParametersDto loanParameters;

    protected FrontBaseCreateTransferRequestDto(
            @JsonProperty("requestType") TransferRequestTypeDto requestType,
            @JsonProperty("parameters") FrontCreateTransferRequestParametersDto parameters,
            @JsonProperty("loanParameters") @Nullable FrontTransferLoanParametersDto loanParameters) {
        this.requestType = requestType;
        this.parameters = parameters;
        this.loanParameters = loanParameters;
    }

    @Schema(description = "Transfer request type.", required = true)
    public Optional<TransferRequestTypeDto> getRequestType() {
        return Optional.ofNullable(requestType);
    }

    @Schema(description = "Transfer request parameters.", required = true)
    public Optional<FrontCreateTransferRequestParametersDto> getParameters() {
        return Optional.ofNullable(parameters);
    }

    @Schema(description = "Loan parameters.")
    public Optional<FrontTransferLoanParametersDto> getLoanParameters() {
        return Optional.ofNullable(loanParameters);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontBaseCreateTransferRequestDto that = (FrontBaseCreateTransferRequestDto) o;
        return requestType == that.requestType &&
                Objects.equals(parameters, that.parameters) &&
                Objects.equals(loanParameters, that.loanParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestType, parameters, loanParameters);
    }

    @Override
    public String toString() {
        return "FrontBaseCreateTransferRequestDto{" +
                "requestType=" + requestType +
                ", parameters=" + parameters +
                ", loanParameters=" + loanParameters +
                '}';
    }
}
