package ru.yandex.intranet.d.web.model.transfers.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Provision transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontCreateProvisionTransferDto @JsonCreator constructor(
    @get:Schema(description = "Source account id.", required = true)
    val sourceAccountId: String?,
    @get:Schema(description = "Source folder id.", required = true)
    val sourceFolderId: String?,
    @get:Schema(description = "Source service id.", required = true)
    val sourceServiceId: String?,
    @get:Schema(description = "Destination account id.", required = true)
    val destinationAccountId: String?,
    @get:Schema(description = "Destination folder id.", required = true)
    val destinationFolderId: String?,
    @get:Schema(description = "Destination service id.", required = true)
    val destinationServiceId: String?,
    @get:Schema(description = "Source account quota resource transfers.", required = true)
    val sourceAccountTransfers: List<FrontCreateQuotaResourceTransferDto>?,
    @get:Schema(description = "Destination account quota resource transfers.", required = true)
    val destinationAccountTransfers: List<FrontCreateQuotaResourceTransferDto>?,
)
