package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quota resource transfer DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Quota resource transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontCreateQuotaResourceTransferDto {

    private final String resourceId;
    private final String delta;
    private final String deltaUnitId;

    @JsonCreator
    public FrontCreateQuotaResourceTransferDto(@JsonProperty("resourceId") String resourceId,
                                               @JsonProperty("delta") String delta,
                                               @JsonProperty("deltaUnitId") String deltaUnitId) {
        this.resourceId = resourceId;
        this.delta = delta;
        this.deltaUnitId = deltaUnitId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Transferred amount.", required = true)
    public Optional<String> getDelta() {
        return Optional.ofNullable(delta);
    }

    @Schema(description = "Transferred resource amount unit id.", required = true)
    public Optional<String> getDeltaUnitId() {
        return Optional.ofNullable(deltaUnitId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontCreateQuotaResourceTransferDto that = (FrontCreateQuotaResourceTransferDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(delta, that.delta) &&
                Objects.equals(deltaUnitId, that.deltaUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, delta, deltaUnitId);
    }

    @Override
    public String toString() {
        return "FrontCreateQuotaResourceTransferDto{" +
                "resourceId='" + resourceId + '\'' +
                ", delta='" + delta + '\'' +
                ", deltaUnitId='" + deltaUnitId + '\'' +
                '}';
    }

    public static final class Builder {

        private String resourceId;
        private String delta;
        private String deltaUnitId;

        private Builder() {
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder delta(String delta) {
            this.delta = delta;
            return this;
        }

        public Builder deltaUnitId(String deltaUnitId) {
            this.deltaUnitId = deltaUnitId;
            return this;
        }

        public FrontCreateQuotaResourceTransferDto build() {
            return new FrontCreateQuotaResourceTransferDto(resourceId, delta, deltaUnitId);
        }

    }

}
