package ru.yandex.intranet.d.web.model.transfers.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.resources.ResourceModel
import ru.yandex.intranet.d.model.transfers.ProvisionTransfer
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel
import java.util.*

@Schema(description = "Provision transfer request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontProvisionTransferDto @JsonCreator constructor(
    @get:Schema(description = "Source account id.", required = true)
    val sourceAccountId: String,
    @get:Schema(description = "Source folder id.", required = true)
    val sourceFolderId: String,
    @get:Schema(description = "Source service id.", required = true)
    val sourceServiceId: String,
    @get:Schema(description = "Destination account id.", required = true)
    val destinationAccountId: String,
    @get:Schema(description = "Destination folder id.", required = true)
    val destinationFolderId: String,
    @get:Schema(description = "Destination service id.", required = true)
    val destinationServiceId: String,
    @get:Schema(description = "Source account quota resource transfers.", required = true)
    val sourceAccountTransfers: List<FrontQuotaResourceTransferDto>,
    @get:Schema(description = "Destination account quota resource transfers.", required = true)
    val destinationAccountTransfers: List<FrontQuotaResourceTransferDto>,
    @get:Schema(description = "Operation id.", required = false)
    val operationId: String?,
) {
    companion object {
        @JvmStatic
        fun fromModel(
            model: ProvisionTransfer,
            resources: Map<String, ResourceModel>,
            unitsEnsembles: Map<String, UnitsEnsembleModel>,
            locale: Locale
        ): FrontProvisionTransferDto {
            return FrontProvisionTransferDto(
                sourceAccountId = model.sourceAccountId,
                sourceFolderId = model.sourceFolderId,
                sourceServiceId = model.sourceServiceId.toString(),
                destinationAccountId = model.destinationAccountId,
                destinationFolderId = model.destinationFolderId,
                destinationServiceId = model.destinationServiceId.toString(),
                sourceAccountTransfers = FrontQuotaResourceTransferDto.fromModels(
                    model.sourceAccountTransfers,
                    resources,
                    unitsEnsembles,
                    locale
                ),
                destinationAccountTransfers = FrontQuotaResourceTransferDto.fromModels(
                    model.destinationAccountTransfers,
                    resources,
                    unitsEnsembles,
                    locale
                ),
                operationId = model.operationId,
            )
        }
    }
}
