package ru.yandex.intranet.d.web.model.transfers.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.LocalDate

/**
 * Transfer request loan borrow parameters DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request loan borrow parameters.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontTransferLoanBorrowParametersDto @JsonCreator constructor(
    @Schema(description = "Due date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    val dueDate: LocalDate?
)
