package ru.yandex.intranet.d.web.model.transfers.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Transfer request loan metadata DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request loan metadata.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class FrontTransferLoanMetaDto @JsonCreator constructor(
    @Schema(description = "Borrow metadata.")
    val borrowMeta: FrontTransferLoanBorrowMetaDto?,
    @Schema(description = "Pay off metadata.")
    val payOffMeta: FrontTransferLoanPayOffMetaDto?,
    @Schema(description = "Provide over commit reserve.")
    val provideOverCommitReserve: Boolean?,
)
