package ru.yandex.intranet.d.web.model.transfers.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Transfer request loan parameters DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request loan parameters.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontTransferLoanParametersDto @JsonCreator constructor(
    @Schema(description = "Borrow parameters.")
    val borrowParameters: FrontTransferLoanBorrowParametersDto?,
    @Schema(description = "Pay off parameters.")
    val payOffParameters: FrontTransferLoanPayOffParametersDto?,
    @Schema(description = "Provide over commit reserve.")
    val provideOverCommitReserve: Boolean? = null
)
