package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Transfer request responsible DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request responsible.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontTransferRequestResponsibleDto {

    private final List<FrontTransferRequestResponsibleGroupDto> responsibleGroups;
    private final List<FrontTransferRequestProviderResponsibleDto> providerResponsible;
    private final FrontReserveResponsibleDto reserveResponsible;

    @JsonCreator
    public FrontTransferRequestResponsibleDto(
            List<FrontTransferRequestResponsibleGroupDto> responsibleGroups,
            List<FrontTransferRequestProviderResponsibleDto> providerResponsible,
            FrontReserveResponsibleDto reserveResponsible) {
        this.responsibleGroups = responsibleGroups;
        this.providerResponsible = providerResponsible;
        this.reserveResponsible = reserveResponsible;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Transfer request responsible groups.", required = true)
    public List<FrontTransferRequestResponsibleGroupDto> getResponsibleGroups() {
        return responsibleGroups;
    }

    @Schema(description = "Transfer request provider responsible.")
    public List<FrontTransferRequestProviderResponsibleDto> getProviderResponsible() {
        return providerResponsible;
    }

    @Schema(description = "Reserve transfer request provider responsible.")
    public Optional<FrontReserveResponsibleDto> getReserveResponsible() {
        return Optional.ofNullable(reserveResponsible);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontTransferRequestResponsibleDto that = (FrontTransferRequestResponsibleDto) o;
        return Objects.equals(responsibleGroups, that.responsibleGroups) && Objects.equals(providerResponsible,
                that.providerResponsible) && Objects.equals(reserveResponsible, that.reserveResponsible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responsibleGroups, providerResponsible, reserveResponsible);
    }

    @Override
    public String toString() {
        return "FrontTransferRequestResponsibleDto{" +
                "responsibleGroups=" + responsibleGroups +
                ", providerResponsible=" + providerResponsible +
                ", reserveResponsible=" + reserveResponsible +
                '}';
    }

    public static final class Builder {

        private final List<FrontTransferRequestResponsibleGroupDto> responsibleGroups = new ArrayList<>();
        private final List<FrontTransferRequestProviderResponsibleDto> providerResponsible = new ArrayList<>();
        private FrontReserveResponsibleDto reserveResponsible;

        private Builder() {
        }

        public Builder addResponsibleGroup(FrontTransferRequestResponsibleGroupDto responsibleGroup) {
            this.responsibleGroups.add(responsibleGroup);
            return this;
        }

        public Builder addProviderResponsible(FrontTransferRequestProviderResponsibleDto providerResponsible) {
            this.providerResponsible.add(providerResponsible);
            return this;
        }

        public Builder reserveResponsible(FrontReserveResponsibleDto reserveResponsible) {
            this.reserveResponsible = reserveResponsible;
            return this;
        }

        public FrontTransferRequestResponsibleDto build() {
            return new FrontTransferRequestResponsibleDto(responsibleGroups, providerResponsible, reserveResponsible);
        }

    }

}
