package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Transfer request responsible with matching services DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request responsible with matching services.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontTransferRequestResponsibleForServiceDto {

    private final String responsibleId;
    private final List<String> serviceIds;

    @JsonCreator
    public FrontTransferRequestResponsibleForServiceDto(@JsonProperty("responsibleId") String responsibleId,
                                                        @JsonProperty("serviceIds") List<String> serviceIds) {
        this.responsibleId = responsibleId;
        this.serviceIds = serviceIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Responsible user id.", required = true)
    public String getResponsibleId() {
        return responsibleId;
    }

    @Schema(description = "Matching service ids.", required = true)
    public List<String> getServiceIds() {
        return serviceIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontTransferRequestResponsibleForServiceDto that = (FrontTransferRequestResponsibleForServiceDto) o;
        return Objects.equals(responsibleId, that.responsibleId) &&
                Objects.equals(serviceIds, that.serviceIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responsibleId, serviceIds);
    }

    @Override
    public String toString() {
        return "FrontTransferRequestResponsibleForServiceDto{" +
                "responsibleId='" + responsibleId + '\'' +
                ", serviceIds=" + serviceIds +
                '}';
    }

    public static final class Builder {

        private final List<String> serviceIds = new ArrayList<>();

        private String responsibleId;

        private Builder() {
        }

        public Builder responsibleId(String responsibleId) {
            this.responsibleId = responsibleId;
            return this;
        }

        public Builder addServiceId(String serviceId) {
            this.serviceIds.add(serviceId);
            return this;
        }

        public FrontTransferRequestResponsibleForServiceDto build() {
            Preconditions.checkNotNull(responsibleId, "ResponsibleId is required");
            return new FrontTransferRequestResponsibleForServiceDto(responsibleId, serviceIds);
        }

    }

}
