package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Transfer request responsible group DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request responsible group.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontTransferRequestResponsibleGroupDto {

    private final List<String> folders;
    private final List<FrontTransferRequestResponsibleForServiceDto> responsibles;

    @JsonCreator
    public FrontTransferRequestResponsibleGroupDto(
            @JsonProperty("folders") List<String> folders,
            @JsonProperty("responsibles") List<FrontTransferRequestResponsibleForServiceDto> responsibles) {
        this.folders = folders;
        this.responsibles = responsibles;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Folder ids.", required = true)
    public List<String> getFolders() {
        return folders;
    }

    @Schema(description = "Responsible users with matching services.", required = true)
    public List<FrontTransferRequestResponsibleForServiceDto> getResponsibles() {
        return responsibles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontTransferRequestResponsibleGroupDto that = (FrontTransferRequestResponsibleGroupDto) o;
        return Objects.equals(folders, that.folders) &&
                Objects.equals(responsibles, that.responsibles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folders, responsibles);
    }

    @Override
    public String toString() {
        return "FrontTransferRequestResponsibleGroupDto{" +
                "folders=" + folders +
                ", responsibles=" + responsibles +
                '}';
    }

    public static final class Builder {

        private final List<String> folders = new ArrayList<>();
        private final List<FrontTransferRequestResponsibleForServiceDto> responsibles = new ArrayList<>();

        private Builder() {
        }

        public Builder addFolder(String folderId) {
            this.folders.add(folderId);
            return this;
        }

        public Builder addResponsible(FrontTransferRequestResponsibleForServiceDto responsible) {
            this.responsibles.add(responsible);
            return this;
        }

        public FrontTransferRequestResponsibleGroupDto build() {
            return new FrontTransferRequestResponsibleGroupDto(folders, responsibles);
        }

    }

}
