package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Transfer request votes DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request votes.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontTransferRequestVotesDto {

    private final List<FrontTransferRequestVoteDto> votes;

    @JsonCreator
    public FrontTransferRequestVotesDto(@JsonProperty("votes") List<FrontTransferRequestVoteDto> votes) {
        this.votes = votes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Transfer request votes list.", required = true)
    public List<FrontTransferRequestVoteDto> getVotes() {
        return votes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontTransferRequestVotesDto that = (FrontTransferRequestVotesDto) o;
        return Objects.equals(votes, that.votes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(votes);
    }

    @Override
    public String toString() {
        return "FrontTransferRequestVotesDto{" +
                "votes=" + votes +
                '}';
    }

    public static final class Builder {

        private final List<FrontTransferRequestVoteDto> votes = new ArrayList<>();

        private Builder() {
        }

        public Builder addVote(FrontTransferRequestVoteDto vote) {
            this.votes.add(vote);
            return this;
        }

        public FrontTransferRequestVotesDto build() {
            return new FrontTransferRequestVotesDto(votes);
        }

    }

}
