package ru.yandex.intranet.d.web.model.transfers.front;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.transfers.TransferRequestVoteTypeDto;

/**
 * Transfer request voting DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Transfer request vote.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontTransferRequestVotingDto {

    private final TransferRequestVoteTypeDto voteType;

    @JsonCreator
    public FrontTransferRequestVotingDto(@JsonProperty("voteType") TransferRequestVoteTypeDto voteType) {
        this.voteType = voteType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Vote type.", required = true)
    public Optional<TransferRequestVoteTypeDto> getVoteType() {
        return Optional.ofNullable(voteType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontTransferRequestVotingDto that = (FrontTransferRequestVotingDto) o;
        return voteType == that.voteType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(voteType);
    }

    @Override
    public String toString() {
        return "FrontTransferRequestVotingDto{" +
                "voteType=" + voteType +
                '}';
    }

    public static final class Builder {

        private TransferRequestVoteTypeDto voteType;

        private Builder() {
        }

        public Builder voteType(TransferRequestVoteTypeDto voteType) {
            this.voteType = voteType;
            return this;
        }

        public FrontTransferRequestVotingDto build() {
            Preconditions.checkNotNull(voteType, "VoteType is required");
            return new FrontTransferRequestVotingDto(voteType);
        }

    }

}
