package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.transfers.TransferRequestTypeDto;
import ru.yandex.intranet.d.web.model.transfers.front.FrontBaseCreateTransferRequestDto;
import ru.yandex.intranet.d.web.model.transfers.front.FrontCreateTransferRequestParametersDto;
import ru.yandex.intranet.d.web.model.transfers.front.FrontTransferLoanParametersDto;

/**
 * FrontDryRunCreateTransferRequestDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontDryRunCreateTransferRequestDto extends FrontBaseCreateTransferRequestDto {
    private final boolean prepareResponsible;
    private final boolean preparePermissions;

    public FrontDryRunCreateTransferRequestDto(TransferRequestTypeDto requestType,
                                               FrontCreateTransferRequestParametersDto parameters,
                                               boolean prepareResponsible,
                                               boolean preparePermissions,
                                               @Nullable FrontTransferLoanParametersDto loanParameters) {
        super(requestType, parameters, loanParameters);
        this.prepareResponsible = prepareResponsible;
        this.preparePermissions = preparePermissions;
    }

    @Schema(description = "'Prepare responsible for request' flag.", required = true)
    public boolean isPrepareResponsible() {
        return prepareResponsible;
    }

    @Schema(description = "'Prepare permissions for request' flag.", required = true)
    public boolean isPreparePermissions() {
        return preparePermissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FrontDryRunCreateTransferRequestDto that = (FrontDryRunCreateTransferRequestDto) o;
        return prepareResponsible == that.prepareResponsible && preparePermissions == that.preparePermissions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), prepareResponsible, preparePermissions);
    }

    @Override
    public String toString() {
        return "FrontDryRunCreateTransferRequestDto{" +
                "prepareResponsible=" + prepareResponsible +
                ", preparePermissions=" + preparePermissions +
                '}';
    }
}
