package ru.yandex.intranet.d.web.model.transfers.front.dryrun

import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Transfer dry-run account quota.")
data class FrontDryRunTransferAccountQuotaDto(
    @get:Schema(description = "Quota resource id", required = true)
    val resourceId: String,
    @get:Schema(description = "Provided quota amount", required = true)
    val providedQuota: String,
    @get:Schema(description = "Provided quota amount unit id", required = true)
    val providedQuotaUnitId: String,
    @get:Schema(description = "Provided quota amount unit name", required = true)
    val providedQuotaUnit: String,
    @get:Schema(description = "Allocated quota amount", required = true)
    val allocatedQuota: String,
    @get:Schema(description = "Allocated quota amount unit id", required = true)
    val allocatedQuotaUnitId: String,
    @get:Schema(description = "Allocated quota amount unit name", required = true)
    val allocatedQuotaUnit: String,
    @get:Schema(description = "Frozen provided quota amount", required = true)
    val frozenProvidedQuota: String,
    @get:Schema(description = "Frozen provided quota amount unit id", required = true)
    val frozenProvidedQuotaUnitId: String,
    @get:Schema(description = "Frozen provided quota amount unit name", required = true)
    val frozenProvidedQuotaUnit: String,
)
