package ru.yandex.intranet.d.web.model.transfers.front.dryrun

import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Transfer dry-run account warnings.")
data class FrontDryRunTransferAccountWarningsDto(
    @get:Schema(description = "Account general messages", required = true)
    val messages: List<String>,
    @get:Schema(description = "Account messages by resource id", required = true)
    val perResource: Map<String, List<String>>,
    @get:Schema(description = "Details by key by resource id", required = true)
    val detailsPerResource: Map<String, Map<String, Any>>
)
