package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * FrontDryRunTransferFolderWarningsDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run folder warnings.")
public class FrontDryRunTransferFolderWarningsDto {
    private final List<String> messages;
    private final Map<String, List<String>> perResource;
    private final Map<String, Map<String, Object>> detailsPerResource;

    public FrontDryRunTransferFolderWarningsDto(List<String> messages, Map<String, List<String>> perResource,
                                                Map<String, Map<String, Object>> detailsPerResource) {
        this.messages = messages;
        this.perResource = perResource;
        this.detailsPerResource = detailsPerResource;
    }

    @Schema(description = "Folder general messages", required = true)
    public List<String> getMessages() {
        return messages;
    }

    @Schema(description = "Folder messages by resource id", required = true)
    public Map<String, List<String>> getPerResource() {
        return perResource;
    }

    @Schema(description = "Details by key by resource id", required = true)
    public Map<String, Map<String, Object>> getDetailsPerResource() {
        return detailsPerResource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferFolderWarningsDto that = (FrontDryRunTransferFolderWarningsDto) o;
        return Objects.equals(messages, that.messages) && Objects.equals(perResource, that.perResource)
                && Objects.equals(detailsPerResource, that.detailsPerResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(messages, perResource, detailsPerResource);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
