package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.Objects;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * FrontDryRunTransferPermissionsDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run permissions.")
public final class FrontDryRunTransferPermissionsDto {
    private final boolean canVote;
    private final boolean canAutoConfirmAsProviderResponsible;
    private final boolean canConfirmSingleHandedly;

    public FrontDryRunTransferPermissionsDto(boolean canVote, boolean canAutoConfirmAsProviderResponsible,
                                             boolean canConfirmSingleHandedly) {
        this.canVote = canVote;
        this.canAutoConfirmAsProviderResponsible = canAutoConfirmAsProviderResponsible;
        this.canConfirmSingleHandedly = canConfirmSingleHandedly;
    }

    @Schema(description = "'User can vote' flag.", required = true)
    public boolean isCanVote() {
        return canVote;
    }

    @Schema(description = "'User can confirm whole request as provider responsible' flag.", required = true)
    public boolean isCanAutoConfirmAsProviderResponsible() {
        return canAutoConfirmAsProviderResponsible;
    }

    @Schema(description = "'User can confirm whole request' flag.", required = true)
    public boolean isCanConfirmSingleHandedly() {
        return canConfirmSingleHandedly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferPermissionsDto that = (FrontDryRunTransferPermissionsDto) o;
        return canVote == that.canVote &&
                canAutoConfirmAsProviderResponsible == that.canAutoConfirmAsProviderResponsible &&
                canConfirmSingleHandedly == that.canConfirmSingleHandedly;
    }

    @Override
    public int hashCode() {
        return Objects.hash(canVote, canAutoConfirmAsProviderResponsible, canConfirmSingleHandedly);
    }

    @Override
    public String toString() {
        return "FrontDryRunTransferPermissionsDto{" +
                "canVote=" + canVote +
                ", canAutoConfirmAsProviderResponsible=" + canAutoConfirmAsProviderResponsible +
                ", canConfirmSingleHandedly=" + canConfirmSingleHandedly +
                '}';
    }
}
