package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.Objects;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * FrontDryRunTransferQuotaDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run quota.")
public final class FrontDryRunTransferQuotaDto {
    private final String resourceId;
    private final String quota;
    private final String quotaUnitId;
    private final String quotaUnit;
    private final String balance;
    private final String balanceUnitId;
    private final String balanceUnit;
    private final String frozenQuota;
    private final String frozenQuotaUnitId;
    private final String frozenQuotaUnit;

    @SuppressWarnings("ParameterNumber")
    public FrontDryRunTransferQuotaDto(String resourceId,
                                       String quota, String quotaUnitId, String quotaUnit,
                                       String balance, String balanceUnitId, String balanceUnit,
                                       String frozenQuota, String frozenQuotaUnitId, String frozenQuotaUnit) {
        this.resourceId = resourceId;
        this.quota = quota;
        this.quotaUnitId = quotaUnitId;
        this.quotaUnit = quotaUnit;
        this.balance = balance;
        this.balanceUnitId = balanceUnitId;
        this.balanceUnit = balanceUnit;
        this.frozenQuota = frozenQuota;
        this.frozenQuotaUnitId = frozenQuotaUnitId;
        this.frozenQuotaUnit = frozenQuotaUnit;
    }

    @Schema(description = "Quota resource id", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Quota amount", required = true)
    public String getQuota() {
        return quota;
    }

    @Schema(description = "Amount unit id", required = true)
    public String getQuotaUnitId() {
        return quotaUnitId;
    }

    @Schema(description = "Amount unit name", required = true)
    public String getQuotaUnit() {
        return quotaUnit;
    }

    @Schema(description = "Quota balance amount", required = true)
    public String getBalance() {
        return balance;
    }

    @Schema(description = "Balance amount unit id", required = true)
    public String getBalanceUnitId() {
        return balanceUnitId;
    }

    @Schema(description = "Balance amount unit name", required = true)
    public String getBalanceUnit() {
        return balanceUnit;
    }

    @Schema(description = "Frozen quota amount", required = true)
    public String getFrozenQuota() {
        return frozenQuota;
    }

    @Schema(description = "Frozen quota amount unit id", required = true)
    public String getFrozenQuotaUnitId() {
        return frozenQuotaUnitId;
    }

    @Schema(description = "Frozen quota amount unit name", required = true)
    public String getFrozenQuotaUnit() {
        return frozenQuotaUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferQuotaDto that = (FrontDryRunTransferQuotaDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(quota, that.quota) &&
                Objects.equals(quotaUnitId, that.quotaUnitId) &&
                Objects.equals(quotaUnit, that.quotaUnit) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(balanceUnitId, that.balanceUnitId) &&
                Objects.equals(balanceUnit, that.balanceUnit) &&
                Objects.equals(frozenQuota, that.frozenQuota) &&
                Objects.equals(frozenQuotaUnitId, that.frozenQuotaUnitId) &&
                Objects.equals(frozenQuotaUnit, that.frozenQuotaUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, quota, quotaUnitId, quotaUnit, balance, balanceUnitId, balanceUnit,
                frozenQuota, frozenQuotaUnitId, frozenQuotaUnit);
    }

    @Override
    public String toString() {
        return "FrontDryRunTransferQuotaDto{" +
                "resourceId='" + resourceId + '\'' +
                ", quota=" + quota +
                ", quotaUnitId='" + quotaUnitId + '\'' +
                ", quotaUnit='" + quotaUnit + '\'' +
                ", balance=" + balance +
                ", balanceUnitId='" + balanceUnitId + '\'' +
                ", balanceUnit='" + balanceUnit + '\'' +
                ", frozenQuota=" + frozenQuota +
                ", frozenQuotaUnitId='" + frozenQuotaUnitId + '\'' +
                ", frozenQuotaUnit='" + frozenQuotaUnit + '\'' +
                '}';
    }
}
