package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.List;
import java.util.Objects;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * FrontDryRunTransferQuotaDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */

@Schema(description = "Transfer dry-run folder quotas.")
public final class FrontDryRunTransferQuotasDto {
    private final String folderId;
    private final List<FrontDryRunTransferQuotaDto> quotas;

    public FrontDryRunTransferQuotasDto(String folderId, List<FrontDryRunTransferQuotaDto> quotas) {
        this.folderId = folderId;
        this.quotas = quotas;
    }

    @Schema(description = "Folder id", required = true)
    public String getFolderId() {
        return folderId;
    }

    @Schema(description = "Quota transfers", required = true)
    public List<FrontDryRunTransferQuotaDto> getQuotas() {
        return quotas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferQuotasDto that = (FrontDryRunTransferQuotasDto) o;
        return Objects.equals(folderId, that.folderId) && Objects.equals(quotas, that.quotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, quotas);
    }

    @Override
    public String toString() {
        return "FrontDryRunTransferQuotasDto{" +
                "folderId='" + folderId + '\'' +
                ", quotas=" + quotas +
                '}';
    }
}
