package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.transfers.TransferRequestTypeDto;

/**
 * Transfer dry-run request DTO.
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontDryRunTransferRequestDto {

    private final TransferRequestTypeDto requestType;
    private final List<FrontDryRunTransferQuotasDto> quotasOld;
    private final List<FrontDryRunTransferQuotasDto> quotasNew;
    private final List<FrontDryRunTransferAccountQuotasDto> accountQuotasOld;
    private final List<FrontDryRunTransferAccountQuotasDto> accountQuotasNew;
    private final FrontDryRunTransferParameters dryRunParameters;

    @SuppressWarnings("ParameterNumber")
    public FrontDryRunTransferRequestDto(TransferRequestTypeDto requestType,
                                         List<FrontDryRunTransferQuotasDto> quotasOld,
                                         List<FrontDryRunTransferQuotasDto> quotasNew,
                                         List<FrontDryRunTransferAccountQuotasDto> accountQuotasOld,
                                         List<FrontDryRunTransferAccountQuotasDto> accountQuotasNew,
                                         FrontDryRunTransferParameters dryRunParameters) {
        this.requestType = requestType;
        this.quotasOld = quotasOld;
        this.quotasNew = quotasNew;
        this.accountQuotasOld = accountQuotasOld;
        this.accountQuotasNew = accountQuotasNew;
        this.dryRunParameters = dryRunParameters;
    }

    @Schema(description = "Request type", required = true)
    public TransferRequestTypeDto getRequestType() {
        return requestType;
    }

    @Schema(description = "Quotas before transfer application", required = true)
    public List<FrontDryRunTransferQuotasDto> getQuotasOld() {
        return quotasOld;
    }

    @Schema(description = "Quotas after transfer application", required = true)
    public List<FrontDryRunTransferQuotasDto> getQuotasNew() {
        return quotasNew;
    }

    @Schema(description = "Account quotas before transfer application", required = true)
    public List<FrontDryRunTransferAccountQuotasDto> getAccountQuotasOld() {
        return accountQuotasOld;
    }

    @Schema(description = "Account quotas after transfer application", required = true)
    public List<FrontDryRunTransferAccountQuotasDto> getAccountQuotasNew() {
        return accountQuotasNew;
    }

    @Schema(description = "Dry run parameters", required = true)
    public FrontDryRunTransferParameters getDryRunParameters() {
        return dryRunParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferRequestDto that = (FrontDryRunTransferRequestDto) o;
        return requestType == that.requestType &&
                Objects.equals(accountQuotasOld, that.accountQuotasOld) &&
                Objects.equals(accountQuotasNew, that.accountQuotasNew) &&
                Objects.equals(quotasOld, that.quotasOld) &&
                Objects.equals(quotasNew, that.quotasNew) &&
                Objects.equals(dryRunParameters, that.dryRunParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestType, quotasOld, quotasNew, accountQuotasOld, accountQuotasNew, dryRunParameters);
    }

    @Override
    public String toString() {
        return "FrontDryRunTransferRequestDto{" +
                "requestType=" + requestType +
                ", quotasOld=" + quotasOld +
                ", quotasNew=" + quotasNew +
                ", accountQuotasOld=" + accountQuotasOld +
                ", accountQuotasNew=" + accountQuotasNew +
                ", dryRunParameters=" + dryRunParameters +
                '}';
    }
}
