package ru.yandex.intranet.d.web.model.transfers.front.dryrun;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * FrontDryRunTransferWarningsDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Transfer dry-run warnings.")
public final class FrontDryRunTransferWarningsDto {
    private final List<String> general;
    private final Map<String, List<String>> perResource;
    private final Map<String, FrontDryRunTransferFolderWarningsDto> perFolder;
    private final Map<String, Map<String, Object>> detailsPerResource;
    private final Map<String, FrontDryRunTransferAccountWarningsDto> perAccount;

    public FrontDryRunTransferWarningsDto(List<String> general, Map<String, List<String>> perResource,
                                          Map<String, FrontDryRunTransferFolderWarningsDto> perFolder,
                                          Map<String, Map<String, Object>> detailsPerResource,
                                          Map<String, FrontDryRunTransferAccountWarningsDto> perAccount) {
        this.general = general;
        this.perResource = perResource;
        this.perFolder = perFolder;
        this.detailsPerResource = detailsPerResource;
        this.perAccount = perAccount;
    }

    @Schema(description = "General messages", required = true)
    public List<String> getGeneral() {
        return general;
    }

    @Schema(description = "Messages by resource id", required = true)
    public Map<String, List<String>> getPerResource() {
        return perResource;
    }

    @Schema(description = "Folder messages by folder id", required = true)
    public Map<String, FrontDryRunTransferFolderWarningsDto> getPerFolder() {
        return perFolder;
    }

    @Schema(description = "Details by key by resource id", required = true)
    public Map<String, Map<String, Object>> getDetailsPerResource() {
        return detailsPerResource;
    }

    @Schema(description = "Account messages by account id", required = true)
    public Map<String, FrontDryRunTransferAccountWarningsDto> getPerAccount() {
        return perAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontDryRunTransferWarningsDto that = (FrontDryRunTransferWarningsDto) o;
        return Objects.equals(general, that.general) && Objects.equals(perResource, that.perResource) &&
                Objects.equals(perFolder, that.perFolder) &&
                Objects.equals(perAccount, that.perAccount) &&
                Objects.equals(detailsPerResource, that.detailsPerResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(general, perResource, perFolder, perAccount, detailsPerResource);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
