package ru.yandex.intranet.d.web.model.units;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Full unit DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Unit of measurement.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FullUnitDto {

    private final String id;
    private final String key;
    private final Map<GrammaticalCaseDto, String> shortNameSingularRu;
    private final Map<GrammaticalCaseDto, String> shortNamePluralRu;
    private final String shortNameSingularEn;
    private final String shortNamePluralEn;
    private final Map<GrammaticalCaseDto, String> longNameSingularRu;
    private final Map<GrammaticalCaseDto, String> longNamePluralRu;
    private final String longNameSingularEn;
    private final String longNamePluralEn;
    private final long base;
    private final long power;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public FullUnitDto(@JsonProperty("id") String id,
                       @JsonProperty("key") String key,
                       @JsonProperty("shortNameSingularRu") Map<GrammaticalCaseDto, String> shortNameSingularRu,
                       @JsonProperty("shortNamePluralRu") Map<GrammaticalCaseDto, String> shortNamePluralRu,
                       @JsonProperty("shortNameSingularEn") String shortNameSingularEn,
                       @JsonProperty("shortNamePluralEn") String shortNamePluralEn,
                       @JsonProperty("longNameSingularRu") Map<GrammaticalCaseDto, String> longNameSingularRu,
                       @JsonProperty("longNamePluralRu") Map<GrammaticalCaseDto, String> longNamePluralRu,
                       @JsonProperty("longNameSingularEn") String longNameSingularEn,
                       @JsonProperty("longNamePluralEn") String longNamePluralEn,
                       @JsonProperty("base") long base,
                       @JsonProperty("power") long power) {
        this.id = id;
        this.key = key;
        this.shortNameSingularRu = shortNameSingularRu;
        this.shortNamePluralRu = shortNamePluralRu;
        this.shortNameSingularEn = shortNameSingularEn;
        this.shortNamePluralEn = shortNamePluralEn;
        this.longNameSingularRu = longNameSingularRu;
        this.longNamePluralRu = longNamePluralRu;
        this.longNameSingularEn = longNameSingularEn;
        this.longNamePluralEn = longNamePluralEn;
        this.base = base;
        this.power = power;
    }

    @Schema(description = "Unique id.")
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per ensemble.")
    public String getKey() {
        return key;
    }

    @Schema(description = "Short name per case, singular, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.")
    public Map<GrammaticalCaseDto, String> getShortNameSingularRu() {
        return shortNameSingularRu;
    }

    @Schema(description = "Short name per case, plural, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.")
    public Map<GrammaticalCaseDto, String> getShortNamePluralRu() {
        return shortNamePluralRu;
    }

    @Schema(description = "Short name, singular, english.")
    public String getShortNameSingularEn() {
        return shortNameSingularEn;
    }

    @Schema(description = "Short name, plural, english.")
    public String getShortNamePluralEn() {
        return shortNamePluralEn;
    }

    @Schema(description = "Long name per case, singular, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.")
    public Map<GrammaticalCaseDto, String> getLongNameSingularRu() {
        return longNameSingularRu;
    }

    @Schema(description = "Long name per case, plural, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.")
    public Map<GrammaticalCaseDto, String> getLongNamePluralRu() {
        return longNamePluralRu;
    }

    @Schema(description = "Long name, singular, english.")
    public String getLongNameSingularEn() {
        return longNameSingularEn;
    }

    @Schema(description = "Long name, plural, english.")
    public String getLongNamePluralEn() {
        return longNamePluralEn;
    }

    @Schema(description = "Unit multiplier base.")
    public long getBase() {
        return base;
    }

    @Schema(description = "Unit multiplier power.")
    public long getPower() {
        return power;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FullUnitDto unitDto = (FullUnitDto) o;
        return base == unitDto.base &&
                power == unitDto.power &&
                Objects.equals(id, unitDto.id) &&
                Objects.equals(key, unitDto.key) &&
                Objects.equals(shortNameSingularRu, unitDto.shortNameSingularRu) &&
                Objects.equals(shortNamePluralRu, unitDto.shortNamePluralRu) &&
                Objects.equals(shortNameSingularEn, unitDto.shortNameSingularEn) &&
                Objects.equals(shortNamePluralEn, unitDto.shortNamePluralEn) &&
                Objects.equals(longNameSingularRu, unitDto.longNameSingularRu) &&
                Objects.equals(longNamePluralRu, unitDto.longNamePluralRu) &&
                Objects.equals(longNameSingularEn, unitDto.longNameSingularEn) &&
                Objects.equals(longNamePluralEn, unitDto.longNamePluralEn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, shortNameSingularRu, shortNamePluralRu, shortNameSingularEn, shortNamePluralEn,
                longNameSingularRu, longNamePluralRu, longNameSingularEn, longNamePluralEn, base, power);
    }

    @Override
    public String toString() {
        return "FullUnitDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", shortNameSingularRu=" + shortNameSingularRu +
                ", shortNamePluralRu=" + shortNamePluralRu +
                ", shortNameSingularEn='" + shortNameSingularEn + '\'' +
                ", shortNamePluralEn='" + shortNamePluralEn + '\'' +
                ", longNameSingularRu=" + longNameSingularRu +
                ", longNamePluralRu=" + longNamePluralRu +
                ", longNameSingularEn='" + longNameSingularEn + '\'' +
                ", longNamePluralEn='" + longNamePluralEn + '\'' +
                ", base=" + base +
                ", power=" + power +
                '}';
    }

}
