package ru.yandex.intranet.d.web.model.units;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Full units ensemble DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Units of measurement ensemble.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FullUnitsEnsembleDto {

    private final String id;
    private final long version;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final boolean fractionsAllowed;
    private final List<FullUnitDto> units;
    private final String key;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public FullUnitsEnsembleDto(@JsonProperty("id") String id,
                                @JsonProperty("version") long version,
                                @JsonProperty("nameEn") String nameEn,
                                @JsonProperty("nameRu") String nameRu,
                                @JsonProperty("descriptionEn") String descriptionEn,
                                @JsonProperty("descriptionRu") String descriptionRu,
                                @JsonProperty("fractionsAllowed") boolean fractionsAllowed,
                                @JsonProperty("units") List<FullUnitDto> units,
                                @JsonProperty("key") String key) {
        this.id = id;
        this.version = version;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.fractionsAllowed = fractionsAllowed;
        this.units = units;
        this.key = key;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Ensemble version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name, english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "Fractions allowed flag.", required = true)
    public boolean isFractionsAllowed() {
        return fractionsAllowed;
    }

    @Schema(description = "Units of measurement.", required = true)
    public List<FullUnitDto> getUnits() {
        return units;
    }

    @Schema(description = "Unique key.", required = true)
    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FullUnitsEnsembleDto that = (FullUnitsEnsembleDto) o;
        return version == that.version &&
                fractionsAllowed == that.fractionsAllowed &&
                Objects.equals(id, that.id) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(units, that.units) &&
                Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, version, nameEn, nameRu, descriptionEn, descriptionRu, fractionsAllowed,
                units, key);
    }

    @Override
    public String toString() {
        return "FullUnitsEnsembleDto{" +
                "id='" + id + '\'' +
                ", version=" + version +
                ", nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", fractionsAllowed=" + fractionsAllowed +
                ", units=" + units +
                ", key='" + key + '\'' +
                '}';
    }

}
