package ru.yandex.intranet.d.web.model.units;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Grammatical case DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Grammatical case.", allowableValues = {"NOMINATIVE", "GENITIVE", "DATIVE", "ACCUSATIVE",
        "INSTRUMENTAL", "PREPOSITIONAL"})
public enum GrammaticalCaseDto {

    NOMINATIVE,
    GENITIVE,
    DATIVE,
    ACCUSATIVE,
    INSTRUMENTAL,
    PREPOSITIONAL,
    UNKNOWN;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static GrammaticalCaseDto fromJsonValue(String value) {
        try {
            return GrammaticalCaseDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return GrammaticalCaseDto.UNKNOWN;
        }
    }

}
