package ru.yandex.intranet.d.web.model.units;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Create unit DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Unit of measurement.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitCreateDto {

    private final String key;
    private final Map<GrammaticalCaseDto, String> shortNameSingularRu;
    private final Map<GrammaticalCaseDto, String> shortNamePluralRu;
    private final String shortNameSingularEn;
    private final String shortNamePluralEn;
    private final Map<GrammaticalCaseDto, String> longNameSingularRu;
    private final Map<GrammaticalCaseDto, String> longNamePluralRu;
    private final String longNameSingularEn;
    private final String longNamePluralEn;
    private final Long base;
    private final Long power;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public UnitCreateDto(@JsonProperty("key") String key,
                         @JsonProperty("shortNameSingularRu") Map<GrammaticalCaseDto, String> shortNameSingularRu,
                         @JsonProperty("shortNamePluralRu") Map<GrammaticalCaseDto, String> shortNamePluralRu,
                         @JsonProperty("shortNameSingularEn") String shortNameSingularEn,
                         @JsonProperty("shortNamePluralEn") String shortNamePluralEn,
                         @JsonProperty("longNameSingularRu") Map<GrammaticalCaseDto, String> longNameSingularRu,
                         @JsonProperty("longNamePluralRu") Map<GrammaticalCaseDto, String> longNamePluralRu,
                         @JsonProperty("longNameSingularEn") String longNameSingularEn,
                         @JsonProperty("longNamePluralEn") String longNamePluralEn,
                         @JsonProperty("base") Long base,
                         @JsonProperty("power") Long power) {
        this.key = key;
        this.shortNameSingularRu = shortNameSingularRu;
        this.shortNamePluralRu = shortNamePluralRu;
        this.shortNameSingularEn = shortNameSingularEn;
        this.shortNamePluralEn = shortNamePluralEn;
        this.longNameSingularRu = longNameSingularRu;
        this.longNamePluralRu = longNamePluralRu;
        this.longNameSingularEn = longNameSingularEn;
        this.longNamePluralEn = longNamePluralEn;
        this.base = base;
        this.power = power;
    }

    @Schema(description = "Key, unique per ensemble.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Short name per case, singular, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.",
            required = true)
    public Optional<Map<GrammaticalCaseDto, String>> getShortNameSingularRu() {
        return Optional.ofNullable(shortNameSingularRu);
    }

    @Schema(description = "Short name per case, plural, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.",
            required = true)
    public Optional<Map<GrammaticalCaseDto, String>> getShortNamePluralRu() {
        return Optional.ofNullable(shortNamePluralRu);
    }

    @Schema(description = "Short name, singular, english.", required = true)
    public Optional<String> getShortNameSingularEn() {
        return Optional.ofNullable(shortNameSingularEn);
    }

    @Schema(description = "Short name, plural, english.", required = true)
    public Optional<String> getShortNamePluralEn() {
        return Optional.ofNullable(shortNamePluralEn);
    }

    @Schema(description = "Long name per case, singular, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.",
            required = true)
    public Optional<Map<GrammaticalCaseDto, String>> getLongNameSingularRu() {
        return Optional.ofNullable(longNameSingularRu);
    }

    @Schema(description = "Long name per case, plural, russian. " +
            "Allowed cases are: NOMINATIVE, GENITIVE, DATIVE, ACCUSATIVE, INSTRUMENTAL, PREPOSITIONAL.",
            required = true)
    public Optional<Map<GrammaticalCaseDto, String>> getLongNamePluralRu() {
        return Optional.ofNullable(longNamePluralRu);
    }

    @Schema(description = "Long name, singular, english.", required = true)
    public Optional<String> getLongNameSingularEn() {
        return Optional.ofNullable(longNameSingularEn);
    }

    @Schema(description = "Long name, plural, english.", required = true)
    public Optional<String> getLongNamePluralEn() {
        return Optional.ofNullable(longNamePluralEn);
    }

    @Schema(description = "Unit multiplier base.", required = true)
    public Optional<Long> getBase() {
        return Optional.ofNullable(base);
    }

    @Schema(description = "Unit multiplier power.", required = true)
    public Optional<Long> getPower() {
        return Optional.ofNullable(power);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitCreateDto that = (UnitCreateDto) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(shortNameSingularRu, that.shortNameSingularRu) &&
                Objects.equals(shortNamePluralRu, that.shortNamePluralRu) &&
                Objects.equals(shortNameSingularEn, that.shortNameSingularEn) &&
                Objects.equals(shortNamePluralEn, that.shortNamePluralEn) &&
                Objects.equals(longNameSingularRu, that.longNameSingularRu) &&
                Objects.equals(longNamePluralRu, that.longNamePluralRu) &&
                Objects.equals(longNameSingularEn, that.longNameSingularEn) &&
                Objects.equals(longNamePluralEn, that.longNamePluralEn) &&
                Objects.equals(base, that.base) &&
                Objects.equals(power, that.power);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, shortNameSingularRu, shortNamePluralRu, shortNameSingularEn, shortNamePluralEn,
                longNameSingularRu, longNamePluralRu, longNameSingularEn, longNamePluralEn, base, power);
    }

    @Override
    public String toString() {
        return "UnitCreateDto{" +
                "key='" + key + '\'' +
                ", shortNameSingularRu=" + shortNameSingularRu +
                ", shortNamePluralRu=" + shortNamePluralRu +
                ", shortNameSingularEn='" + shortNameSingularEn + '\'' +
                ", shortNamePluralEn='" + shortNamePluralEn + '\'' +
                ", longNameSingularRu=" + longNameSingularRu +
                ", longNamePluralRu=" + longNamePluralRu +
                ", longNameSingularEn='" + longNameSingularEn + '\'' +
                ", longNamePluralEn='" + longNamePluralEn + '\'' +
                ", base=" + base +
                ", power=" + power +
                '}';
    }

}
