package ru.yandex.intranet.d.web.model.units;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Unit DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Unit of measurement.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitDto {

    private final String id;
    private final String key;
    private final String shortName;
    private final String longName;
    private final long base;
    private final long power;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public UnitDto(@JsonProperty("id") String id,
                   @JsonProperty("key") String key,
                   @JsonProperty("shortName") String shortName,
                   @JsonProperty("longName") String longName,
                   @JsonProperty("base") long base,
                   @JsonProperty("power") long power) {
        this.id = id;
        this.key = key;
        this.shortName = shortName;
        this.longName = longName;
        this.base = base;
        this.power = power;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per ensemble.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Short name.", required = true)
    public String getShortName() {
        return shortName;
    }

    @Schema(description = "Long name.", required = true)
    public String getLongName() {
        return longName;
    }

    @Schema(description = "Unit multiplier base.", required = true)
    public long getBase() {
        return base;
    }

    @Schema(description = "Unit multiplier power.", required = true)
    public long getPower() {
        return power;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitDto unitDto = (UnitDto) o;
        return base == unitDto.base &&
                power == unitDto.power &&
                Objects.equals(id, unitDto.id) &&
                Objects.equals(key, unitDto.key) &&
                Objects.equals(shortName, unitDto.shortName) &&
                Objects.equals(longName, unitDto.longName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, shortName, longName, base, power);
    }

    @Override
    public String toString() {
        return "UnitDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", shortName='" + shortName + '\'' +
                ", longName='" + longName + '\'' +
                ", base=" + base +
                ", power=" + power +
                '}';
    }

}
