package ru.yandex.intranet.d.web.model.units;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Create units ensemble DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Units of measurement ensemble.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitsEnsembleCreateDto {

    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final Boolean fractionsAllowed;
    private final List<UnitCreateDto> units;
    private final String key;

    @JsonCreator
    public UnitsEnsembleCreateDto(@JsonProperty("nameEn") String nameEn,
                                  @JsonProperty("nameRu") String nameRu,
                                  @JsonProperty("descriptionEn") String descriptionEn,
                                  @JsonProperty("descriptionRu") String descriptionRu,
                                  @JsonProperty("fractionsAllowed") Boolean fractionsAllowed,
                                  @JsonProperty("units") List<UnitCreateDto> units,
                                  @JsonProperty("key") String key) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.fractionsAllowed = fractionsAllowed;
        this.units = units;
        this.key = key;
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "Fractions allowed flag.", required = true)
    public Optional<Boolean> getFractionsAllowed() {
        return Optional.ofNullable(fractionsAllowed);
    }

    @Schema(description = "Units of measurement.", required = true)
    public Optional<List<UnitCreateDto>> getUnits() {
        return Optional.ofNullable(units);
    }

    @Schema(description = "Unique key.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitsEnsembleCreateDto that = (UnitsEnsembleCreateDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(fractionsAllowed, that.fractionsAllowed) &&
                Objects.equals(units, that.units) &&
                Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, fractionsAllowed, units, key);
    }

    @Override
    public String toString() {
        return "UnitsEnsembleCreateDto{" +
                "nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", fractionsAllowed=" + fractionsAllowed +
                ", units=" + units +
                ", key='" + key + '\'' +
                '}';
    }

}
