package ru.yandex.intranet.d.web.model.units;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Units ensemble DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Units of measurement ensemble.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitsEnsembleDto {

    private final String id;
    private final long version;
    private final String name;
    private final String description;
    private final boolean fractionsAllowed;
    private final List<UnitDto> units;
    private final String key;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public UnitsEnsembleDto(@JsonProperty("id") String id,
                            @JsonProperty("version") long version,
                            @JsonProperty("name") String name,
                            @JsonProperty("description") String description,
                            @JsonProperty("fractionsAllowed") boolean fractionsAllowed,
                            @JsonProperty("units") List<UnitDto> units,
                            @JsonProperty("key") String key) {
        this.id = id;
        this.version = version;
        this.name = name;
        this.description = description;
        this.fractionsAllowed = fractionsAllowed;
        this.units = units;
        this.key = key;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Ensemble version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "Fractions allowed flag.", required = true)
    public boolean isFractionsAllowed() {
        return fractionsAllowed;
    }

    @Schema(description = "Units of measurement.", required = true)
    public List<UnitDto> getUnits() {
        return units;
    }

    @Schema(description = "Unique key.", required = true)
    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitsEnsembleDto that = (UnitsEnsembleDto) o;
        return version == that.version &&
                fractionsAllowed == that.fractionsAllowed &&
                Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(units, that.units) &&
                Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, version, name, description, fractionsAllowed, units, key);
    }

    @Override
    public String toString() {
        return "UnitsEnsembleDto{" +
                "id='" + id + '\'' +
                ", version=" + version +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", fractionsAllowed=" + fractionsAllowed +
                ", units=" + units +
                ", key='" + key + '\'' +
                '}';
    }

}
