package ru.yandex.intranet.d.web.model.units;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.PatchedValue;

/**
 * Patch resource type DTO.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Units of measurement ensemble.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitsEnsemblePatchDto {

    private final PatchedValue<String> nameEn;
    private final PatchedValue<String> nameRu;
    private final PatchedValue<String> descriptionEn;
    private final PatchedValue<String> descriptionRu;

    @JsonCreator
    public UnitsEnsemblePatchDto(PatchedValue<String> nameEn,
                                 PatchedValue<String> nameRu,
                                 PatchedValue<String> descriptionEn,
                                 PatchedValue<String> descriptionRu) {
        this.nameEn = nameEn == null ? PatchedValue.noChanged() : nameEn;
        this.nameRu = nameRu == null ? PatchedValue.noChanged() : nameRu;
        this.descriptionEn = descriptionEn == null ? PatchedValue.noChanged() : descriptionEn;
        this.descriptionRu = descriptionRu == null ? PatchedValue.noChanged() : descriptionRu;
    }

    @Schema(description = "Name, english.", implementation = String.class)
    public PatchedValue<String> getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", implementation = String.class)
    public PatchedValue<String> getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", implementation = String.class)
    public PatchedValue<String> getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", implementation = String.class)
    public PatchedValue<String> getDescriptionRu() {
        return descriptionRu;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitsEnsemblePatchDto that = (UnitsEnsemblePatchDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu);
    }

    @Override
    public String toString() {
        return "UnitsEnsemblePutDto{" +
                "nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                '}';
    }

}
