package ru.yandex.intranet.d.web.model.units;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put units ensemble DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Units of measurement ensemble.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitsEnsemblePutDto {

    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public UnitsEnsemblePutDto(@JsonProperty("nameEn") String nameEn,
                               @JsonProperty("nameRu") String nameRu,
                               @JsonProperty("descriptionEn") String descriptionEn,
                               @JsonProperty("descriptionRu") String descriptionRu) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitsEnsemblePutDto that = (UnitsEnsemblePutDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu);
    }

    @Override
    public String toString() {
        return "UnitsEnsemblePutDto{" +
                "nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                '}';
    }

}
